<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;
if ( get_option( 'uw_104_license_status', false) != 'valid' ){
	add_action( 'admin_notices', 'uniwoodmart_104_license_notice' );
}
function uniwoodmart_104_license_notice() {
    ?>
    <div class="notice notice-error">
        <p>قالب یونی وودمارت نصب شده است ولی تمام امکانات آن در دسترس نیست. برای استفاده از تمامی امکانات قالب، از منوهای پیشخوان وردپرس خود وارد بخش لایسنس‌ها > لایسنس وودمارت شوید و لایسنس خود را فعال کنید.</p>
    </div>
    <?php
}
function uw_104_license_menu() {
	if ( empty ( $GLOBALS['admin_page_hooks']['uw_PLUGIN_LICENSE_PAGE'] ) ) {
		add_menu_page(
		'لایسنس‌ها',
		'لایسنس‌ها',
		'manage_options',
		'uw_PLUGIN_LICENSE_PAGE',
		'uw_104_parent_license_page',
		/*string $icon_url =*/ '',
		66
		);
	}
	add_submenu_page(
	'uw_PLUGIN_LICENSE_PAGE',
	'لایسنس قالب وودمارت',
	'لایسنس وودمارت',
	'manage_options',
	'uw_104_PLUGIN_LICENSE_PAGE',
	'uw_104_license_page',
	/*int $position =*/ null
	);
}
add_action('admin_menu', 'uw_104_license_menu');
function uw_104_parent_license_page() {
	?>
	<div class="wrap">
		<h1>لایسنس‌ها</h1>
		<p>برای فعال سازی لایسنس هر یک از محصولات می توانید از منوی لایسنس‌ها و زیرمنوی لایسنس محصول مورد نظر اقدام کنید.</p>
	</div>
	<?php
}
function uw_104_license_page() {
	$license = get_option( 'uw_104_license_key' );
	$status  = get_option( 'uw_104_license_status' );
	$uw_product_id  = get_option( 'uw_104_theme' );
	?>
	<div class="wrap">
		<h1>لایسنس قالب وودمارت</h1>
		<p>کلید لایسنس خود را وارد و ذخیره کنید. لایسنس را می توانید از حساب کاربری خود در سایت یونی وودمارت، بخش لایسنس‌ها دریافت کنید: <a href='https://uniwoodmart.ir/profile/api-keys/' target='_blank'>دریافت لایسنس</a></p>
		<form method="post" action="options.php">
			<?php settings_fields('uw_104_license'); ?>
			<table class="form-table">
				<tbody>
					<?php if( $status != 'valid' ) { ?>
					<tr valign="top">
						<th scope="row" valign="top">کلید لایسنس</th>
						<td>
							<input id="uw_104_license_key" name="uw_104_license_key" type="password" class="regular-text" value="<?php esc_attr_e( $license ); ?>" />
						</td>
					</tr>
					<tr valign="top">
						<th scope="row" valign="top">نسخه یونی وودمارت</th>
						<td>
							<input type="radio" id="personal" name="uw_104_theme" <?php echo ($uw_product_id == 350 ? 'checked':''); ?> value="350"><label for="personal">پرسونال</label><br>
							<input type="radio" id="pro" name="uw_104_theme" <?php echo ($uw_product_id == 351 ? 'checked':''); ?> value="351"><label for="pro">پرو</label><br>
							<input type="radio" id="plus" name="uw_104_theme" <?php echo ($uw_product_id == 352 ? 'checked':''); ?> value="352"><label for="plus">پلاس</label><br>
							<input type="radio" id="buisiness" name="uw_104_theme" <?php echo ($uw_product_id == 353 ? 'checked':''); ?> value="353"><label for="buisiness">بیزنس</label><br>
						</td>
					</tr>
					<tr valign="top">
						<th scope="row" valign="top">وضعیت فعال‌سازی</th>
						<td>
								<span style="color:red;">قالب شما فعال نیست. برای استفاده از همه امکانات قالب باید لایسنس خود را فعال کنید.</span>
								<?php wp_nonce_field( 'uw_104_nonce', 'uw_104_nonce' ); ?>
						</td>
					</tr>
					<?php } else { ?>	
					<tr valign="top">
						<th scope="row" valign="top">وضعیت فعال‌سازی</th>
						<td>
								<span style="color:green;">قالب شما فعال است.</span>
								<?php wp_nonce_field( 'uw_104_nonce', 'uw_104_nonce' ); ?>
						</td>
					</tr>					
					<?php } ?>	
				</tbody>
			</table>
			<?php
			if( $status != 'valid' ) {
			submit_button();
			}
			?>
		</form>
	</div>
	<?php
}
function uw_104_register_option() {
	register_setting('uw_104_license', 'uw_104_license_key', 'uw_104_license' );
	register_setting('uw_104_license', 'uw_104_theme', 'uw_104_license' );
}
add_action('admin_init', 'uw_104_register_option');
function uw_104_license( $new ) {
	$old = get_option( 'uw_104_license_key' );
	if( $old && $old != $new ) {
		delete_option( 'uw_104_license_status' );
	}
	return $new;
}
function uw_104_activate_license() {
	global $pagenow; 
	if ( ( get_option( 'uw_104_license_key' ) ) && ( 'admin.php' === $pagenow ) && ( 'uw_104_PLUGIN_LICENSE_PAGE' === $_GET['page'] ) ) {
		uw_104_setnewstat();
	}
}
add_action('admin_init', 'uw_104_activate_license');
function uw_104_setnewstat() {
	$activated = 'inactive';
	//params
	//$uw_plugin_name = 'no-need';
	$uw_product_id  = get_option( 'uw_104_theme' );
	//$uw_slug = 'no-need';
	$uw_version = 0.0;
	$uw_license = trim( get_option( 'uw_104_license_key' ) );
	$uw_home_url = home_url();
	$uw_instance = base64_encode( $uw_home_url .'#' . $uw_product_id );
	$uw_object = $uw_home_url;
	$api_params = array(
		'wc-api' => 'wc-am-api',
		'wc_am_action' => 'activate',
		//'plugin_name' => $uw_plugin_name,
		'product_id' => $uw_product_id,
		//'slug' => $uw_slug,
		'version' => $uw_version,
		'api_key' => $uw_license,
		'instance' => $uw_instance,
		'object' => $uw_object,
		
	);
	$response = wp_remote_post( 'https://uniwoodmart.ir/', array( 'timeout' => 30, 'sslverify' => false, 'body' => $api_params ) );
	if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {
		$message =  ( is_wp_error( $response ) && ! empty( $response->get_error_message() ) ) ? $response->get_error_message() : __( 'خطایی رخ داد! دوباره امتحان کنید.' );
	} else {
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		if ( false === $license_data->success ) {
			$message = $license_data->error;
		}
	}
	if ( ! empty( $message ) ) {	
		if ( 'Cannot activate API Key. The API Key has already been activated with the same unique instance ID sent with this request.' == $message ) {
			$activated = 'active';
		}
		else {
			return;
		}
	}
	if ( 'active' == $license_data->activated ) {
		$activated = 'active';
	}
	uw_104_setstat( $activated );
}
function uw_104_setstat( $stat ) {
	if ( 'active' == $stat ) {
		update_option( 'uw_104_license_status', 'valid' );
	}
	else {
		update_option( 'uw_104_license_status', 'invalid' );
	}
}
function uw_104_getstat() {
	$stat = get_option( 'uw_104_license_status' );
	return $stat;
}