;

/*
 *
 * SAMPLE USAGE DETAILS :
 * 
 * sliders structure :
 *
 * [
 *  {
 *     color: "COLOR",
 *     position: "POSITION" //0 to 100 without % symbol
 *  },
 *  {
 *     ....
 *     ....
 *  },
 *  ....
 * ]
 *
 */

'use strict';

//make me jquery UI  independent
if (typeof jQuery.fn.draggable === "undefined") {

    (function($) {

        $.fn.draggable = function() {
            //console.log(this);
            var ele = document.getElementById(this.attr("id"));
            ele.style.top = "121px";
            Drag.init(ele, null, 26, 426, 86, 86);
            return this;
        };

    }(jQuery));

}


jQuery.fn.gradX = function(id, _options) {

    var options = {
        targets: [], //[element selector] -> array
        sliders: [],
        direction: 'left',
        //if linear left | top | right | bottom
        //if radial left | center | right , top | center | bottom
        type: 'linear', //linear | circle | ellipse
        code_shown: false, //false | true
        change: function(sliders, styles,type,direction) {
            //nothing to do here by default
        }
    };

    //make global
    var gradx = {
        rand_RGB: [],
        rand_pos: [],
        id: null,
        slider_ids: [],
        slider_index: 0, //global index for sliders
        sliders: [], //contains styles of each slider
        direction: "left", //direction of gradient or position of centre in case of radial gradients
        type: "linear", //linear or radial
        shape: "cover", //radial gradient size
        slider_hovered: [],
        jQ_present: true,
        code_shown: false,
        load_jQ: function() {

            //handle any library conflicts here
            this.gx = jQuery;
        },
        //very lazy to replace this by jQuery
        add_event: function(el, evt, evt_func) {
            add_event(el, evt, evt_func);
        },
        get_random_position: function() {
            var pos;

            do {
                pos = parseInt(Math.random() * 100);
            }
            while (this.rand_pos.indexOf(pos) > -1);

            this.rand_pos.push(pos);
            return pos;

        },
        get_random_rgb: function() {

            var R, G, B, color;

            do {
                R = parseInt(Math.random() * 255);
                G = parseInt(Math.random() * 255);
                B = parseInt(Math.random() * 255);

                color = "rgb(" + R + ", " + G + ", " + B + ")";
            }
            while (this.rand_RGB.indexOf(color) > -1);

            this.rand_RGB.push(color);
            return color;

        },
        //if target element is specified the target's style (background) is updated
        update_target: function(values) {

            if (this.targets.length > 0) {
                //target elements exist

                var i, j, ele, len = this.targets.length, v_len = values.length;
                for (i = 0; i < len; i++) {
                    ele = this.gx(this.targets[i]);

                    for (j = 0; j < v_len; j++) {
                        ele.css("background-image", values[j]);
                    }

                }
            }
        },
        //apply styles on fly
        apply_style: function(ele, value) {
            var type = this.type;

            if (this.type != 'linear') {
                type = 'radial';
            }

            var values = [
                "-webkit-" + type + "-gradient(" + value + ")",
                "-moz-" + type + "-gradient(" + value + ")",
                "-ms-" + type + "-gradient(" + value + ")",
                "-o-" + type + "-gradient(" + value + ")",
                type + "-gradient(" + value + ")"
            ];

            var len = values.length, css = '';

            while (len > 0) {
                len--;
                this.panel.css("background", values[len]);
                css += "background: " + values[len] + ";\n";
            }

            //call the userdefined change function
            this.change(this.sliders, values,this.type,this.direction);
            this.update_target(values);


          //  this.gx('#gradx_code').html(css);

        },
        //on load
        apply_default_styles: function() {
            this.update_style_array()
            var value = this.get_style_value();
            this.apply_style(this.panel, value);
        },
        //update the slider_values[] while dragging
        update_style_array: function() {

            this.sliders = [];

            var len = this.slider_ids.length,
                i, offset, position, id;

            for (i = 0; i < len; i++) {
                id = "#" + this.slider_ids[i];
                offset = parseInt(this.me.find(id).css("left"));
                position = parseInt((offset / this.container_width) * 100);
                position -= 6; //TODO: find why this is required
                this.sliders.push([this.me.find(id).css("background-color"), position]);

            }

            this.sliders.sort(function(A, B) {
                if (A[1] > B[1])
                    return 1;
                else
                    return -1;
            });
        },
        //creates the complete css background value to later apply style
        get_style_value: function() {
            var len = this.slider_ids.length;

            if (len === 1) {
                //since only one slider , so simple background

                style_str = this.sliders[0][0];
            } else {
                var style_str = "", suffix = "";
                for (var i = 0; i < len; i++) {
                    if (this.sliders[i][1] == "") {
                        style_str += suffix + (this.sliders[i][0]);

                    } else {
                        if (this.sliders[i][1] > 100) {
                            this.sliders[i][1] = 100;
                        }
                        style_str += suffix + (this.sliders[i][0] + " " + this.sliders[i][1] + "%");

                    }
                    suffix = " , "; //add , from next iteration
                }

                if (this.type == 'linear') {
                    //direction, [color stoppers]
                    style_str = this.direction + " , " + style_str; //add direction for gradient
                } else {
                    //position, type size, [color stoppers]
                    style_str = this.direction + " , " + this.type + " " + this.shape + " , " + style_str;
                }
            }

            return style_str;
        },
        //@input rgb string rgb(<red>,<green>,<blue>)
        //@output rgb object of form { r: <red> , g: <green> , b : <blue>}
        get_rgb_obj: function(rgb) {

            //rgb(r,g,b)
            rgb = rgb.split("(");
            //r,g,b)
            rgb = rgb[1];
            //r g b)
            rgb = rgb.split(",");

            return {
                r: parseInt(rgb[0]),
                g: parseInt(rgb[1]),
                b: parseInt(rgb[2]),
                a: rgb[3]
            };

        },
        load_info: function(ele) {
            var id = "#" + ele.id;
            ele.current_slider_id = id;
            //check if current clicked element is an slider
            if (ele.slider_ids.indexOf(ele.id) > -1) { //javascript does not has # in its id

                var color = ele.me.find(id).css("backgroundColor");
                //but what happens if @color is not in RGB ? :(
                var rgb = ele.get_rgb_obj(color);

                var left = ele.me.find(id).css("left");
                if (parseInt(left) >= 26 && parseInt(left) <= 426) {
                    if (parseInt(left) <= 90) {
                        left = '90px';
                    }else if (parseInt(left) >= 360){
                        left = '360px';
                    }
                    ele.me.find("#gradx_slider_info") //info element cached before
                        .css("left", left)
                        .show();

                }

                ele.set_colorpicker(rgb, ele);
            }

        },
        //add slider
        add_slider: function(sliders, currentGradx) {
            var id, slider, k, position, value, delta;

            if (sliders.length === 0) {
                sliders = [//default sliders
                    {
                        color: currentGradx.get_random_rgb(),
                        position: currentGradx.get_random_position() //x percent of gradient panel(400px)
                    },
                    {
                        color: currentGradx.get_random_rgb(),
                        position: currentGradx.get_random_position()
                    }
                ];

            }

            obj = sliders;

            for (k in obj) {

                if (typeof obj[k].position === "undefined")
                    break;

                //convert % to px based on containers width
                var delta = 26; //range: 26px tp 426px
                position = parseInt((obj[k].position * currentGradx.container_width) / 100) + delta + "px";

                id = "gradx_slider_" + (currentGradx.slider_index); //create an id for this slider
                currentGradx.sliders.push(
                    [
                        obj[k].color,
                        obj[k].position
                    ]
                );

                currentGradx.slider_ids.push(id); //for reference wrt to id

                slider = "<div class='gradx_slider' id='" + id + "'></div>";
                currentGradx.me.find("#gradx_start_sliders_" + currentGradx.id).append(slider);

                currentGradx.me.find('#' + id).css("backgroundColor", obj[k].color).css("left", position);
                currentGradx.slider_index++;
            }

            for (var i = 0, len = this.slider_ids.length; i < len; i++) {

                currentGradx.me.find('#' + currentGradx.slider_ids[i]).draggable({
                    containment: 'parent',
                    axis: 'x',
                    start: function() {
                        if (currentGradx.jQ_present)
                            currentGradx.current_slider_id = "#" + currentGradx.me.find(this).attr("id"); //got full jQuery power here !
                    },
                    drag: function() {

                        currentGradx.update_style_array();
                        currentGradx.apply_style(currentGradx.panel, currentGradx.get_style_value());
                        var left = currentGradx.me.find(currentGradx.current_slider_id).css("left");


                        if (parseInt(left) >= 26 && parseInt(left) <= 426) {
                            if (parseInt(left) <= 90) {
                                left = '90px';
                            }else if (parseInt(left) >= 360){
                                left = '360px';
                            }
                            currentGradx.container.find("#gradx_slider_info") //info element cached before
                                .css("left", left)
                                .show();

                        }
                        var color = currentGradx.me.find(currentGradx.current_slider_id).css("backgroundColor");
                        //but what happens if @color is not in RGB ? :(
                        var rgb = currentGradx.get_rgb_obj(color);
                        currentGradx.cp.spectrum("set", rgb);

                    }

                }).click(function() {
                    currentGradx.load_info(currentGradx);
                    return false;
                });
            }
        },
        set_colorpicker: function(clr, ele) {
            ele.cp.spectrum({
                move: function(color) {
                    if (ele.current_slider_id != false) {
                        var rgba = color.toRgbString();
                        ele.me.find(ele.current_slider_id).css('background-color', rgba);
                        ele.update_style_array();
                        ele.apply_style(ele.panel, ele.get_style_value());
                    }
                },
                change: function() {
                    gradx.gx("#gradx_slider_info").hide();
                },
                flat: true,
                showAlpha: true,
                color: clr,
                clickoutFiresChange: true,
                showInput: true,
                showButtons: false

            });
        },
        generate_options: function(options) {

            var len = options.length,
                name, state,
                str = '';

            for (var i = 0; i < len; i++) {

                name = options[i].split(" ");

                name = name[0];

                if (i < 2) {
                    state = name[1];
                } else {
                    state = '';
                }

                name = name.replace("-", " ");

                str += '<option value=' + options[i] + ' ' + state + '>' + name + '</option>';

            }

            return str;
        },
        generate_radial_options: function( currentGradx ) {

            var options;
            options = ["horizontal-center disabled", "center selected", "left", "right"];
            currentGradx.me.find('#gradx_gradient_subtype').html(currentGradx.generate_options(options));

            options = ["vertical-center disabled", "center selected", "top", "bottom"];
            currentGradx.me.find('#gradx_gradient_subtype2').html(currentGradx.generate_options(options)).show();

        },
        generate_linear_options: function( currentGradx ) {
            var options = ["horizontal-center disabled", "left selected", "right", "top", "bottom"];
            currentGradx.me.find('#gradx_gradient_subtype').html(currentGradx.generate_options(options));

            currentGradx.me.find('#gradx_gradient_subtype2').hide();

        },
        destroy: function() {
            var options = {
                targets: [], //[element selector] -> array
                sliders: [],
                direction: 'left',
                //if linear left | top | right | bottom
                //if radial left | center | right , top | center | bottom 
                type: 'linear', //linear | circle | ellipse
                code_shown: false, //false | true
                change: function(sliders, styles) {
                    //nothing to do here by default
                }
            };

            for (var k in options) {
                gradx[k] = options[k];
            }
        },
        load_gradx: function(id, sliders) {
            this.me = this.gx(id);
            this.id = id.replace("#", "");
            id = this.id;
            this.current_slider_id = false;
            var currentGradx = this;
            var html = "<div class='gradx'>\n\
                        <div class='gradx_slectboxes'>\n\
                        <select id='gradx_gradient_type' class='gradx_gradient_type'>\n\
                            <option value='linear'>Linear</option>\n\
                            <option value='circle'>Radial - Circle</option>\n\
                            <option value='ellipse'>Radial - Ellipse</option>\n\
                        </select>\n\
                        <select id='gradx_gradient_subtype' class='gradx_gradient_type'>\n\
                            <option id='gradx_gradient_subtype_desc' value='gradient-direction' disabled>gradient direction</option>\n\
                            <option value='left' selected>Left</option>\n\
                            <option value='right'>Right</option>\n\
                            <option value='top'>Top</option>\n\
                            <option value='bottom'>Bottom</option>\n\
                        </select>\n\
                        <select id='gradx_gradient_subtype2' class='gradx_gradient_type gradx_hide'>\n\
                        </select>\n\
                        <select id='gradx_radial_gradient_size' class='gradx_gradient_type gradx_hide'>\n\
                        </select>\n\
                        </div>\n\
                        <div class='gradx_container' id='gradx_" + id + "'>\n\
                            <div id='gradx_stop_sliders_" + id + "'></div>\n\
                            <div class='gradx_panel' id='gradx_panel_" + id + "'></div>\n\
                            <div class='gradx_start_sliders' id='gradx_start_sliders_" + id + "'>\n\
                                <div class='cp-default' id='gradx_slider_info'>\n\
                                    <div id='gradx_slider_controls'>\n\
                                        <div id='gradx_delete_slider' class='gradx_btn'><i class='icon icon-remove'></i>delete</div>\n\
                                    </div>\n\
                                    <div id='gradx_slider_content'></div>\n\
                                </div> \n\
                            </div>\n\
                        </div>\n\
                        <div id='gradx_add_slider' class='gradx_add_slider gradx_btn'><i class='icon icon-add'></i>add</div>\n\
                        <div id='gradx_show_presets' style='display:none' class='gradx_show_presets gradx_btn'><i class='icon icon-preset'></i><span>show presets</span></div>\n\
                        <textarea class='gradx_code' id='gradx_code'></textarea>\n\
                    </div>";

            this.me.html(html);


            //generates html to select the different gradient sizes
            // *only available for radial gradients
            var gradient_size_val = ["gradient-size disabled", "closest-side selected", "closest-corner", "farthest-side", "farthest-corner", "contain", "cover"],
                option_str = '';


            option_str = currentGradx.generate_options(gradient_size_val);

            currentGradx.me.find('#gradx_radial_gradient_size').html(option_str);

            //cache divs for fast reference

            currentGradx.container = currentGradx.me.find("#gradx_" + id);
            currentGradx.panel = currentGradx.me.find("#gradx_panel_" + id);
            //.hide();
            //this.info.hide();
            currentGradx.container_width = 400 //HARDCODE;
            currentGradx.add_slider(sliders, currentGradx);


            currentGradx.add_event(document, 'click', function() {
//            if(!this.jQ_present){
                if (!currentGradx.slider_hovered[id]) {
                    currentGradx.container.find("#gradx_slider_info").hide();
                    return false;
                }
            });

            currentGradx.me.find('#gradx_add_slider').click( function() {
                currentGradx.add_slider([
                    {
                        color: currentGradx.get_random_rgb(),
                        position: currentGradx.get_random_position() //no % symbol
                    }
                ], currentGradx);
                currentGradx.update_style_array();
                currentGradx.apply_style(currentGradx.panel, currentGradx.get_style_value());//(where,style)

            });

            //cache the element
            currentGradx.cp = this.container.find('#gradx_slider_content');

            //call the colorpicker plugin
            currentGradx.set_colorpicker("blue", currentGradx);

            currentGradx.me.find('#gradx_delete_slider').click(function() {
                currentGradx.gx(currentGradx.current_slider_id).remove();
                currentGradx.gx("#gradx_slider_info").hide();
                var id = currentGradx.current_slider_id.replace("#", "");

                //remove all references from array for current deleted slider

                for (var i = 0; i < currentGradx.slider_ids.length; i++) {
                    if (currentGradx.slider_ids[i] == id) {
                        currentGradx.slider_ids.splice(i, 1);
                    }
                }

                //apply modified style after removing the slider
                currentGradx.update_style_array();
                currentGradx.apply_style(currentGradx.panel, currentGradx.get_style_value());

                currentGradx.current_slider_id = false; //no slider is selected

            });

            currentGradx.me.find('#gradx_code').focus(function() {
                var $this = currentGradx.gx(this);
                $this.select();

                // Work around Chrome's little problem
                $this.mouseup(function() {
                    // Prevent further mouseup intervention
                    $this.unbind("mouseup");
                    return false;
                });
            });

            currentGradx.me.find('#gradx_gradient_type').change(function() {

                var type = currentGradx.gx(this).val(), options, option_str = '';
                if (type !== "linear") {
                    //this.gx('#gradx_radial_gradient_size').show();

                    currentGradx.generate_radial_options( currentGradx );
                } else {

                    currentGradx.generate_linear_options( currentGradx );
                    currentGradx.me.find('#gradx_gradient_subtype').val("left");
                }

                currentGradx.type = type;
                currentGradx.direction = currentGradx.me.find('#gradx_gradient_subtype').val();
                currentGradx.apply_style(currentGradx.panel, currentGradx.get_style_value());//(where,style)
            });

            //change type onload userdefined
            if (this.type !== "linear") {
                currentGradx.me.find('#gradx_gradient_type').val(this.type);
                currentGradx.generate_radial_options( currentGradx );

                var h, v;

                if (currentGradx.direction !== 'left') {
                    //user has passed his own direction
                    var center;
                    if (currentGradx.direction.indexOf(",") > -1) {
                        center = currentGradx.direction.split(",");
                    } else {
                        //tolerate user mistakes
                        center = currentGradx.direction.split(" ");
                    }

                    h = center[0];
                    v = center[1];

                    //update the center points in the corr. select boxes
                    currentGradx.me.find('#gradx_gradient_subtype').val(h);
                    currentGradx.me.find('#gradx_gradient_subtype2').val(v);
                } else {
                    var h = currentGradx.me.find('#gradx_gradient_subtype').val();
                    var v = currentGradx.me.find('#gradx_gradient_subtype2').val();
                }
                currentGradx.direction = h + " " + v;
                currentGradx.apply_style(currentGradx.panel, currentGradx.get_style_value());//(where,style)
            } else {

                //change direction if not left
                if (currentGradx.direction !== 'left') {
                    currentGradx.me.find('#gradx_gradient_subtype').val(currentGradx.direction);
                }
            }

            currentGradx.me.find('#gradx_gradient_subtype').change(function() {

                if (currentGradx.type === 'linear') {
                    currentGradx.direction = currentGradx.me.find(this).val();
                } else {
                    var h = currentGradx.gx(this).val();
                    var v = currentGradx.me.find('#gradx_gradient_subtype2').val();
                    currentGradx.direction = h + " " + v;
                }
                currentGradx.apply_style(currentGradx.panel, currentGradx.get_style_value());//(where,style)

            });

            currentGradx.me.find('#gradx_gradient_subtype2').change(function() {

                var h = currentGradx.me.find('#gradx_gradient_subtype').val();
                var v = currentGradx.gx(this).val();
                currentGradx.direction = h + " " + v;
                currentGradx.apply_style(currentGradx.panel, currentGradx.get_style_value());//(where,style)

            });

            //not visible
            currentGradx.me.find('#gradx_radial_gradient_size').change(function() {
                currentGradx.shape = currentGradx.gx(this).val();
                currentGradx.apply_style(currentGradx.panel, currentGradx.get_style_value());//(where,style)

            });

            currentGradx.me.find('#gradx_show_code').click(function() {

                if (currentGradx.code_shown) {
                    //hide it

                    currentGradx.code_shown = false;
                    this.gx('#gradx_show_code span').text("show the code");
                    this.gx("#gradx_code").hide();
                }
                else {
                    //show it

                    this.gx('#gradx_show_code span').text("hide the code");
                    this.gx("#gradx_code").show();
                    currentGradx.code_shown = true;
                }
            });

            //show or hide onload
            if (this.code_shown) {
                //show it

                this.gx('#gradx_show_code span').text("hide the code");
                this.gx("#gradx_code").show();

            }

            this.add_event(document.getElementById('gradx_slider_info'), 'mouseout', function() {
                currentGradx.slider_hovered[id] = false;
            });
            this.add_event(document.getElementById('gradx_slider_info'), 'mouseover', function() {
                currentGradx.slider_hovered[id] = true;
            });
        }
    };



    function add_event(element, event, event_function)
    {
        if (element.attachEvent) //Internet Explorer
            element.attachEvent("on" + event, function() {
                event_function.call(element);
            });
        else if (element.addEventListener) //Firefox & company
            element.addEventListener(event, event_function, false); //don't need the 'call' trick because in FF everything already works in the right way
    }
    ;



    //load jQuery library into gradx.gx
    this.gradx = gradx
    this.gradx.load_jQ();

    /* merge _options into options */
    this.gradx.gx.extend(options, _options);

    //apply options to gradx object

    for (var k in options) {

        //load the options into gradx object
        this.gradx[k] = options[k];

    }

    this.gradx.load_gradx(id, this.gradx.sliders);
    this.gradx.apply_default_styles();


};
